/*
**
**  !!! GENERATED FILE !!! DO NOT CHANGE !!!
**
*/

/**HEADER********************************************************************
* 
* Copyright (c) 2012 Freescale Semiconductor;
* All Rights Reserved
*
*************************************************************************** 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************
*
* $FileName: fxlc95000eval_ram_config.h$
* $Version : 1.0.0.0$
* $Date    : May-15-2012$
*
* Comments:
*
*   MQX configuration set: for FXLC95000 devices
*
*END************************************************************************/

#ifndef __fxlc95000eval_ram_config_h__
#define __fxlc95000eval_ram_config_h__


/* 
 ** CR ENGR00296203
 ** 
 ** When MQX_TASK_EXIT_DISABLE_MEM_DEALLOC is defined as 1,
 ** then mqx will deallocate a task's stack memory  when the
 ** task exits but will NOT deallocate any dynamically 
 ** allocated memory that created by that task. See ta_dest.c. 
 **
 ** When MQX_TASK_EXIT_DISABLE_MEM_DEALLOC is defined as 0,
 ** then mqx will deallocate a task's stack memory  and
 ** dynamically allocated memory created during the task's
 ** runtime. 
 */
#ifndef MQX_TASK_EXIT_DISABLE_MEM_DEALLOC
#define MQX_TASK_EXIT_DISABLE_MEM_DEALLOC             1
#endif


/* Disable heavy weight components */

/* 
** When MQX_USE_LOGS is defined as 1,
** then mqx will compile in the support code for log component.
*/
#ifndef MQX_USE_LOGS         
#define MQX_USE_LOGS                                  0
#endif


/* 
** When MQX_USE_SEMAPHORES is defined as 1,
** then mqx will compile in the support code for Semaphores
*/
#ifndef MQX_USE_SEMAPHORES   
#define MQX_USE_SEMAPHORES                            1
#endif

/* 
** When MQX_USE_EVENTS is defined as 1,
** then mqx will compile in the support code for event component.
*/
#ifndef MQX_USE_EVENTS
#define MQX_USE_EVENTS                                0
#endif


/* 
** When MQX_USE_TIMER is defined as 1,
** then mqx will compile in the support code for timer component.
*/
#ifndef MQX_USE_TIMER        
#define MQX_USE_TIMER                                 0
#endif


/* 
** When MQX_USE_MUTEXES is defined as 1,
** then mqx will compile in the support code for mutex component.
*/
#ifndef MQX_USE_MUTEXES
#define MQX_USE_MUTEXES                               0
#endif


/* 
** When MQX_USE_PARTITIONS is defined as 1,
** then mqx will compile in the support code for memory with fixed-size blocks.
*/
#ifndef MQX_USE_PARTITIONS
#define MQX_USE_PARTITIONS                            0
#endif


/* 
** When MQX_USE_NAME is defined as 1,
** then mqx will compile in the support code for name component.
*/
#ifndef MQX_USE_NAME
#define MQX_USE_NAME                                  1
#endif


/* 
** When MQX_USE_MESSAGES is defined as 1,
** then mqx will compile in the support code for messages.
*/
#ifndef MQX_USE_MESSAGES
#define MQX_USE_MESSAGES                              0
#endif


/* 
** When MQX_USE_LWMEM_ALLOCATOR is defined as 1,
** then mqx will use the light weight memory functions
** to allocate and free memory 
*/
#ifndef MQX_USE_LWMEM_ALLOCATOR           
#define MQX_USE_LWMEM_ALLOCATOR                       1
#endif


/* 
** When MQX_USE_SW_WATCHDOGS is defined as 1,
** then mqx will compile in the support code for software watchdog timers.
*/
#ifndef MQX_USE_SW_WATCHDOGS 
#define MQX_USE_SW_WATCHDOGS                          0
#endif


/* 
** When MQX_USE_IPC is defined as 1,
** then mqx will compile in the support code for Interprocessor communication.
*/
#ifndef MQX_USE_IPC
#define MQX_USE_IPC                                   0
#endif





/* Other configuration */

/*
** When MQX_DEFAULT_TIME_SLICE_IN_TICKS is define as 1,
** then the default time slice in the task template structure
** is in units of ticks. Changing this to 0 will change the units
** to milliseconds. This also affects the time slice field in the
** task template since this is used to set a task's default time
** slice.
*/
#ifndef MQX_DEFAULT_TIME_SLICE_IN_TICKS
#define MQX_DEFAULT_TIME_SLICE_IN_TICKS               1
#endif


/*
** When MQX_LWLOG_TIME_STAMP_IN_TICKS is define as 0,
** then the time stamp in the light weight log component
** is in seconds, milliseconds, and microseconds. Changing this
** to 1 will causes the time stamp to be in ticks which is not
** as readable, but has much less overhead.
*/
#ifndef MQX_LWLOG_TIME_STAMP_IN_TICKS   
#define MQX_LWLOG_TIME_STAMP_IN_TICKS                 1
#endif


/* 
** When MQX_TIMER_USES_TICKS_ONLY, the timer task will *only* process
** timer periodic and one-shot requests using ticks for timeout
** reporting, rather than the MQX2.40 milliseconds/seconds.
*/
#ifndef MQX_TIMER_USES_TICKS_ONLY       
#define MQX_TIMER_USES_TICKS_ONLY                     1
#endif


/*
** When MQX_EXTRA_TASK_STACK_ENABLE is defined as 1,
** code is compiled in to reserve extra memory at the top of stack 
** in every task, if desired. Both "OS Changer" and the MetaWare C/C++
** runtime want additional per-task variables.
*/
#ifndef MQX_EXTRA_TASK_STACK_ENABLE     
#define MQX_EXTRA_TASK_STACK_ENABLE                   0
#endif


/* 
** When MQX_IS_MULTI_PROCESSOR is defined as 1,
** then code is compiled in to support multiple processor MQX systems.
*/
#ifndef MQX_IS_MULTI_PROCESSOR          
#define MQX_IS_MULTI_PROCESSOR                        0
#endif


/* 
** When MQX_MUTEX_HAS_POLLING is defined as 1,
** then extra code will be compiled in to support the
** mutex options: MUTEX_SPIN_ONLY and MUTEX_LIMITED_SPIN
*/
#ifndef MQX_MUTEX_HAS_POLLING           
#define MQX_MUTEX_HAS_POLLING                         0
#endif


/* 
** When MQX_USE_INLINE_MACROS is defined as 1,
** certain internal utility functions called by MQX will
** be made "inline" rather than by function calls.  This allows the user
** to optimize for time or code space.  Inlining optimizes for time,
** not inlining optimizes for space.
*/
#ifndef MQX_USE_INLINE_MACROS             
#define MQX_USE_INLINE_MACROS                         0
#endif


/* 
** When MQX_USE_IDLE_TASK is defined as 1,
** the kernel will create the idle task otherwise, no actual
** task will run when one is not ready to run.
*/
#ifndef MQX_USE_IDLE_TASK
#define MQX_USE_IDLE_TASK                             0
#endif


/* 
** When MQX_HAS_TIME_SLICE is defined as 1,
** then code is compiled in to support time sliced tasks.
*/
#ifndef MQX_HAS_TIME_SLICE
#define MQX_HAS_TIME_SLICE                            0
#endif


/* 
** When MQX_KERNEL_LOGGING is defined as 1, 
** calls to write to the kernel log will be added to some kernel functions at 
** function entry (with parameters) and function exit (with error codes).
**
** The MQX functions that have logging compiled in will run slower, however
** it is only when the logging is enabled for the function that performance
** will be affected.
**
** The logging of specific functions can be controlled using the 
** _klog_control function.
**
** The default value of this define is dependent upon the PSP. Please see
** source\psp\<psp src dir>\psptypes.h
*/
#ifndef MQX_KERNEL_LOGGING
#define MQX_KERNEL_LOGGING 0
#endif



#ifndef MQX_ROM_VECTORS
#define MQX_ROM_VECTORS                               1
#endif

#ifndef MQX_SPARSE_ISR_TABLE
#define MQX_SPARSE_ISR_TABLE                          1

#ifndef MQX_SPARSE_ISR_SHIFT
#define MQX_SPARSE_ISR_SHIFT                          3
#endif

#endif /* MQX_SPARSE_ISR_TABLE */



/* 
** When MQX_COMPONENT_DESTRUCTION is defined as 1,
** the kernel will handle the destruction of a kernel component object
** (such as a semaphore or event)
*/
// In order to release mem used by task, must also set MQX_COMPONENT_DESTRUCTION.
#ifndef MQX_TASK_DESTRUCTION     
#define MQX_TASK_DESTRUCTION                          1
#endif


/* 
** When MQX_EXIT_ENABLED is defined as 1,
** code is compiled in to allow the application to return from _mqx().
*/
#ifndef MQX_EXIT_ENABLED
#define MQX_EXIT_ENABLED                              0
#endif


/*
** MFS settings
*/

#ifndef MFSCFG_MINIMUM_FOOTPRINT
#define MFSCFG_MINIMUM_FOOTPRINT                      1
#endif

/*
** RTCS settings
*/

#ifndef RTCS_MINIMUM_FOOTPRINT
#define RTCS_MINIMUM_FOOTPRINT                        1
#endif

#ifndef RTCSCFG_ENABLE_LWDNS
#define RTCSCFG_ENABLE_LWDNS                1
#endif

#endif
/* EOF */
